function getUrlVars() {
    var vars = {};
    var parts = window.location.href.replace(/[?&]+([^=&]+)=([^&]*)/gi, function(m, key, value) {
        vars[key] = value;
    });
    return vars;
}

function agFadeIn(el, time) {
    // Fade in effect
    el.style.opacity = 0;

    var last = +new Date();
    var tick = function() {
        el.style.opacity = +el.style.opacity + (new Date() - last) / time;
        last = +new Date();

        if (+el.style.opacity < 1) {
            (window.requestAnimationFrame && requestAnimationFrame(tick)) || setTimeout(tick, 16);
        }
    };
  
    tick();
}

function JQueryCode() {
    jQuery(function() {
        
        // Fonction pour récupérer des variables depuis le document parent (cas du mode PREVIEW)
        function getParamValue(paramName)
        {
            var url = window.location.search.substring(1); //get rid of "?" in querystring
            var qArray = url.split('&'); //get key-value pairs
            for (var i = 0; i < qArray.length; i++) 
            {
                var pArr = qArray[i].split('='); //split key and value
                if (pArr[0] == paramName) 
                    return pArr[1]; //return value
            }
        }

        // Si on est en mode PREVIEW xPos et yPos du document sont définies, on les récupères donc
        if ((typeof getParamValue('xPos') !== 'undefined') || (typeof getParamValue('yPos') !== 'undefined')){
            var xPos = getParamValue('xPos');
            var yPos = getParamValue('yPos');
        }
        
        // Affichage de la preuve sociale (dernier avis s'il existe)
        if ((agSiteId == 32 || agSiteId == 2588) && typeof id_product !== 'undefined') {
            console.log("ok");
            productReview='https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/reviewProductSocial.php?siteId='+agSiteId+'&productId='+id_product;
            jQuery("body").append('<div class="sagProductReviewSocial" onclick="showReviews(); return false;"></div>');
            jQuery.get(productReview, function(data) {
                // use the result
                jQuery( "div.sagProductReviewSocial" ).attr('style','display:none !important');
                jQuery( "div.sagProductReviewSocial" ).html( data );
                if($(window).width() >= 800) {
                    jQuery( "div.sagProductReviewSocial" ).delay(5000).fadeIn(1000);
                    jQuery( "div.sagProductReviewSocial" ).delay(9000).fadeOut(1000);
                }
            });
        }	
        
        // Create DOM element
        jQuery("body").append('<div class="agJsWidget"></div>');

        // Pour intégration hors prestashop avec transmition de l'id widget
        if (typeof agWidgetId !== 'undefined'){
            jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/jsWidget.php?siteId='+agSiteId+'&widgetId='+agWidgetId;
        }			
        if ((typeof xPos !== 'undefined') && (typeof yPos !== 'undefined') && (typeof agWidgetId !== 'undefined')){
            jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/jsWidget.php?siteId='+agSiteId+'&widgetId='+agWidgetId+'&xPos='+xPos+'&yPos='+yPos;
        } 
        else {
            jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/cache/jsv2/'+agSiteId+'.html';
        }
        
        var sagUrl = window.location.href; // Returns full URL
        
        if ((sagUrl.indexOf("preview.php") >= 0)) {
            jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/jsWidget.php?nocache=true&siteId='+agSiteId+'&widgetId='+agWidgetId;
        }
        
        // Disable widget on iframes unless if we are on configuration page
        if ((sagUrl.indexOf("preview.php") >= 0) || self === top || window.location === window.parent.location) {
            var iCanUseOn = !!jQuery.fn.on;

            if(iCanUseOn) {
                // Si On est une fonction
                // On désactive la fonction détectant les appels ajax (fix PayPal conflict)
                jQuery(document).off('ajaxComplete');
            }
                
            jQuery.get(jsWidget, function(data) {
                // use the result
                jQuery( "div.agJsWidget" ).attr('style','display:none !important');
                jQuery( "div.agJsWidget" ).html( data );
                jQuery( "div.agJsWidget" ).fadeIn(2000);
            });
                
            if(iCanUseOn) {
                // On désactive la fonction détectant les appels ajax (fix PayPal conflict)
                jQuery(document).on('ajaxComplete');
                
            }
        }
    });
}

function agVanillaCode()
{
    // Fonction pour récupérer des variables depuis le document parent (cas du mode PREVIEW)
    function getParamValue(paramName) {
        var url = window.location.search.substring(1); //get rid of "?" in querystring
        var qArray = url.split('&'); //get key-value pairs
        for (var i = 0; i < qArray.length; i++) {
            var pArr = qArray[i].split('='); //split key and value
            if (pArr[0] == paramName) 
                return pArr[1]; //return value
        }
    }

    // Si on est en mode PREVIEW xPos et yPos du document sont définies, on les récupères donc
    var xPos, yPos;
    if ((typeof getParamValue('xPos') !== 'undefined') || (typeof getParamValue('yPos') !== 'undefined')) {
        xPos = getParamValue('xPos');
        yPos = getParamValue('yPos');
    }

    // Affichage de la preuve sociale (dernier avis s'il existe)
    if (typeof agSiteId !== 'undefined' && (agSiteId == 32 || agSiteId == 2588) && typeof id_product !== 'undefined') {
        console.log("ok");
        var productReview = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/reviewProductSocial.php?siteId=' + agSiteId + '&productId=' + id_product;
        var sagProductReviewSocial = document.createElement('div');
        sagProductReviewSocial.className = "sagProductReviewSocial";
        sagProductReviewSocial.onclick = function() {
            showReviews();
            return false;
        };
        document.body.appendChild(sagProductReviewSocial);

        fetch(productReview)
            .then(response => response.text())
            .then(data => {
                sagProductReviewSocial.style.display = 'none';
                sagProductReviewSocial.innerHTML = data;
                if (window.innerWidth >= 800) {
                    setTimeout(() => {
                        sagProductReviewSocial.style.display = 'block';
                    }, 5000);
                    setTimeout(() => {
                        sagProductReviewSocial.style.display = 'none';
                    }, 14000);
                }
            });
    }

    // Create DOM element
    var agJsWidget = document.createElement('div');
    agJsWidget.className = "agJsWidget";
    document.body.appendChild(agJsWidget);

    // Pour intégration hors prestashop avec transmition de l'id widget
    var jsWidget;
    if (typeof agWidgetId !== 'undefined') {
        jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/jsWidget.php?siteId=' + agSiteId + '&widgetId=' + agWidgetId;
    }

    if ((typeof xPos !== 'undefined') && (typeof yPos !== 'undefined') && (typeof agWidgetId !== 'undefined')) {
        jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/jsWidget.php?siteId=' + agSiteId + '&widgetId=' + agWidgetId + '&xPos=' + xPos + '&yPos=' + yPos;
    } else {
        jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/cache/jsv2/' + agSiteId + '.html';
    }
    
    var sagUrl = window.location.href; // Returns full URL

    if (sagUrl.indexOf("preview.php") >= 0) {
        jsWidget = 'https://www.societe-des-avis-garantis.fr/wp-content/plugins/ag-core/widgets/jsWidget.php?nocache=true&siteId=' + agSiteId + '&widgetId=' + agWidgetId;
    }

    // Disable widget on iframes unless if we are on configuration page
    if (sagUrl.indexOf("preview.php") >= 0 || self === top || window.location === window.parent.location) {
        fetch(jsWidget)
            .then(response => response.text())
            .then(data => {
                agJsWidget.style.display = 'none';
                agJsWidget.innerHTML = data;
                //agJsWidget.style.display = 'block';
                agFadeIn(agJsWidget, 2000);
            });
    } 
}

// Event listener for JS Widget
if(window.addEventListener) {
    window.addEventListener("load", playSagWidget, false);
} else {
    window.attachEvent && window.attachEvent("onload", playSagWidget);
}

function playSagWidget(e) {
    if(typeof agVanillaMode !== 'undefined' && agVanillaMode && typeof sagCalled == 'undefined') {
        agVanillaCode();
        window.sagCalled = 1;
    } else {
        // Function to load jquery if not already loaded
        if(typeof jQuery == 'undefined') {
            var headTag = document.getElementsByTagName("head")[0];
            var jqTag = document.createElement('script');
            jqTag.type = 'text/javascript';
            jqTag.src = '//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js';
            if(typeof sagCalled == 'undefined') {
                jqTag.onload = JQueryCode;
                window.sagCalled = 1;
            }
            headTag.appendChild(jqTag);
        }
        else {
            if(typeof sagCalled == 'undefined') {
                JQueryCode();
                window.sagCalled = 1;
            }
        }
    }
}

// Sinon jQuery était défini
if(typeof jQuery != 'undefined') {
    if(typeof agVanillaMode !== 'undefined' && agVanillaMode && typeof sagCalled == 'undefined') {
        agVanillaCode();
        window.sagCalled = 1;
    } else {
        var iCanUseOn = !!jQuery.fn.on;
        if(iCanUseOn) {
            jQuery(document).on('ready', function() {
                if(typeof sagCalled == 'undefined') {
                    JQueryCode();
                    window.sagCalled = 1;
                }
            });
        }
        else {
            // Pour les versions plus anciennes de jQuery
            jQuery(document).ready(function() {
                if(typeof sagCalled == 'undefined') {
                    JQueryCode();
                    window.sagCalled = 1;
                }
            });
        }
    }
}